# 🌭 Dog Melina - Sistema de Delivery

![Dog Melina Logo](./client/public/images/logo.png)

Sistema completo de delivery de lanches (cachorro-quente e xis) desenvolvido com React, TypeScript e TailwindCSS.

## 🎯 Sobre o Projeto

**Dog Melina** é um Progressive Web App (PWA) moderno para delivery de lanches, focado em proporcionar uma experiência fluida e intuitiva tanto para clientes quanto para administradores.

## ✨ Funcionalidades

### Para Clientes
- 🏠 **Página Inicial** com banner rotativo de promoções
- 🔍 **Busca** de produtos em tempo real
- 📱 **Navegação por categorias** (Cachorro-quente, Xis, Combos, Bebidas)
- 🍔 **Detalhes de produtos** com opção de adicionais
- 🛒 **Carrinho de compras** funcional
- 💳 **Checkout** completo
- 📦 **Confirmação de pedidos**
- 👤 **Perfil do usuário**

### Para Administradores
- 🔐 **Login administrativo** seguro
- 📊 **Dashboard** com visão geral de pedidos
- 📦 **Gerenciamento de produtos**
- 💰 **PDV (Ponto de Venda)**
- ⚙️ **Configurações** do sistema
- 📈 **Relatórios** de vendas

## 🛠️ Tecnologias Utilizadas

### Frontend
- **React 19** - Biblioteca JavaScript para interfaces
- **TypeScript** - Tipagem estática
- **Vite** - Build tool moderna e rápida
- **TailwindCSS 4** - Framework CSS utility-first
- **Wouter** - Roteamento leve
- **Radix UI** - Componentes acessíveis
- **Framer Motion** - Animações fluidas
- **Lucide React** - Ícones modernos

### Backend
- **Express.js** - Framework Node.js
- **Node.js 22** - Runtime JavaScript

### UI/UX
- **shadcn/ui** - Componentes de interface
- **Sonner** - Sistema de notificações
- **React Hook Form** - Gerenciamento de formulários
- **Zod** - Validação de schemas

## 📦 Estrutura do Projeto

```
burger-delivery/
├── client/                 # Frontend React
│   ├── public/
│   │   └── images/        # Imagens e assets
│   │       └── logo.png   # Logo Dog Melina
│   └── src/
│       ├── pages/         # 14 páginas da aplicação
│       ├── components/    # Componentes reutilizáveis
│       ├── contexts/      # Contextos React (Admin, Theme)
│       ├── lib/           # Utilitários e dados
│       ├── App.tsx        # Componente principal
│       └── index.css      # Estilos globais
├── server/                # Backend Express
│   └── index.ts
├── shared/                # Código compartilhado
├── package.json
├── vite.config.ts
└── tsconfig.json
```

## 🚀 Como Executar

### Pré-requisitos
- Node.js 22+
- pnpm 10+

### Instalação

1. **Instalar dependências:**
```bash
pnpm install
```

2. **Aprovar builds (se necessário):**
```bash
pnpm approve-builds
```

### Desenvolvimento

```bash
pnpm dev
```

O projeto estará disponível em `http://localhost:3000`

### Build para Produção

```bash
pnpm build
```

### Executar em Produção

```bash
pnpm start
```

## 🎨 Design System

### Paleta de Cores (Dark Theme)
- **Primary:** `#FF6B35` (Laranja vibrante)
- **Background:** `#1A1A1A` (Preto suave)
- **Foreground:** `#FFFFFF` (Branco)
- **Secondary:** Tons de cinza
- **Accent:** Laranja com variações

### Filosofia de Design
O projeto utiliza uma abordagem **Modern Organic** com elementos de **Neo-Brutalism**, criando uma interface:
- **Acolhedora** - Cores quentes que estimulam o apetite
- **Moderna** - Dark mode por padrão
- **Intuitiva** - Navegação clara e direta
- **Responsiva** - Otimizada para mobile-first

## 📱 Catálogo de Produtos

### Cachorro-Quente (8 opções)
- Especial - R$ 19,00
- Bacon - R$ 22,00
- Frango - R$ 22,00
- Calabresa - R$ 20,00
- Duplo - R$ 22,00
- Filé - R$ 27,00
- Filé com Bacon - R$ 30,00
- Frango com Bacon - R$ 25,00

### Xis (9 opções)
- Especial - R$ 22,00
- Calabresa - R$ 22,00
- Frango - R$ 23,00
- Bacon - R$ 27,00
- Filé - R$ 30,00
- Filé com Bacon - R$ 33,00
- Coração - R$ 27,00
- Frango com Bacon - R$ 27,00
- Duplo - R$ 30,00

### Combos (4 opções)
- Cachorro-Quente + Bebida - R$ 24,90
- Xis + Bebida - R$ 27,90
- Combo Duplo - R$ 44,90
- Combo Trio - R$ 54,90

### Bebidas (2 opções)
- Coca-Cola Gelada 350ml - R$ 6,90
- Refrigerante 2L - R$ 12,00

## 🐛 Correções Realizadas

### Bug #1: App.tsx - Estrutura JSX Duplicada ✅
**Problema:** Hierarquia incorreta de providers causando erro de compilação
**Solução:** Reestruturação completa com ordem correta:
```
ErrorBoundary → AdminProvider → ThemeProvider → TooltipProvider → Router
```

### Bug #2: Menu.tsx - Filtro de Categorias ✅
**Problema:** Filtro de categorias não atualizava ao clicar nos botões
**Solução:** Implementação de useState e useEffect para sincronizar com URL

## ✅ Testes Realizados

- ✅ Compilação TypeScript sem erros
- ✅ Instalação de dependências completa
- ✅ Servidor de desenvolvimento funcionando
- ✅ Logo atualizado e exibido corretamente
- ✅ Banner rotativo operacional
- ✅ Busca de produtos funcional
- ✅ Filtro de categorias corrigido e testado
- ✅ Página de detalhes do produto
- ✅ Sistema de adicionais com cálculo de preço
- ✅ Navegação entre páginas
- ✅ Dark theme aplicado

## 📝 Scripts Disponíveis

```json
{
  "dev": "vite --host",
  "build": "vite build && esbuild server/index.ts --platform=node --packages=external --bundle --format=esm --outdir=dist",
  "start": "NODE_ENV=production node dist/index.js",
  "preview": "vite preview --host",
  "check": "tsc --noEmit",
  "format": "prettier --write ."
}
```

## 🔐 Acesso Admin

Para acessar o painel administrativo:
1. Clique no ícone de cadeado no canto superior direito da página inicial
2. Faça login com as credenciais de administrador
3. Acesse o dashboard e todas as funcionalidades admin

## 🌟 Próximas Melhorias Sugeridas

1. **Backend Real**
   - API REST completa
   - Banco de dados (PostgreSQL/MySQL)
   - Autenticação JWT

2. **Pagamento**
   - Integração com Stripe/PagSeguro
   - PIX
   - Cartão de crédito

3. **Notificações**
   - Push notifications
   - SMS/WhatsApp
   - Email

4. **Rastreamento**
   - Mapa em tempo real
   - Status do pedido
   - Tempo estimado de entrega

5. **PWA Completo**
   - Service Worker
   - Instalação no dispositivo
   - Modo offline

## 📄 Licença

MIT License - Sinta-se livre para usar este projeto como base para seus próprios projetos.

## 👨‍💻 Desenvolvimento

Projeto desenvolvido com foco em qualidade, performance e experiência do usuário.

---

**Dog Melina** - Delivery de qualidade! 🌭🍔
